#pragma once

#include "tool.h"

//! @defgroup UND_xxx Undecorator flags
//@{
#define UND_NoImport		(1<<0)
#define UND_CppStyle		(1<<1)
#define UND_CStyle			(1<<2)
//@}

class WintruderDbgFile;
/*!	@brief undecorates microsoft or borland decorated symbol names
*/
class UndecoratorTool :	public Tool
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief undecorate symbolic name
		@param name decorated name of symbol
		@param buffer buffer for undecorated name
		@param size size of @em buffer
		@param flags a combination of @ref UND_xxx
		@returns size of bytes returned in buffer
			- 0 failure
			- a value greater @em size if buffer too small
			- length of string returned otherwise
	*/
	virtual UINT Undecorate(LPCSTR name,LPSTR buffer,UINT size,DWORD flags);
	/*! @brief allocate undecorated symbol generator
		@param pDbgFile pointer to WintruderDbgFile
		@returns pointer to Undecorator
		@remarks Undecorator adds all undecorated symbols to @em pDbgFile
	*/
	virtual Symbol* AllocGenerator(WintruderDbgFile *pDbgFile);
};

/*!	@brief undecorated symbol generator of UndecoratorTool
*/
class Undecorator : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*! @brief add decorated name to scheduler
		@param name decorated name to add
		@param storage _sym_storage_data of @em name
		@param pArgList if @em name specifies a procedure @em pArgList may points to a comma 
			separated string containing argument names
		@returns nonezero if successful
	*/		
	virtual BOOL AddName(LPCSTR name,_sym_storage_data &storage,LPCSTR pArgList=NULL);
	/*! @brief generate symbols from scheduled decorated names
		@param pszProgress if not NULL the text to be shown in progress indicator
		@returns nonezero if any symbol added
		@remarks this function can be called only once per instance of Undecorator
	*/
	virtual BOOL Generate(LPCSTR pszProgress);
};
