/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

/*!	@brief continuous address range
*/
class Range : public SymbolBackRef
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief union of ranges
		@param start start value of second range
		@param end end value of second range
		@remarks defined as @n
			[e,f] = [a,b] _cup_ [c,d] := [min(a,c),max(b,d)]
	*/
	virtual void Union(DWORDLONG start,DWORDLONG end)=0;
	/*!	@brief minus of ranges
		@param start start value of second range
		@param end end value of second range
		@remarks defined as @n
			[e,f] = [a,b] / [c,d] := ( [a,b] _cap_ [0,c-1] ) _cup_ ([a,b] _cap_ [d+1,-1]) @n
			using the definition of Union() and Intersect()
	*/
	virtual void Minus(DWORDLONG start,DWORDLONG end)=0;
	/*!	@brief intersection of ranges
		@param start start value of intersection
		@param end end value of intersection
		@remarks defined as @n
			[e,f] = [a,b] _cap_ [c,d] := [max(a,c),min(b,d)] @n
			empty if f<e
	*/
	virtual void Intersect(DWORDLONG start,DWORDLONG end)=0;
	/*!	@brief test if value is element of range
		@param value value to test
		@return nonezero if value in range
	*/
	virtual BOOL Contains(DWORDLONG value) const =0;
};

/*!	@brief collection of distinct Range symbols
*/
class RangeArray : public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual void Minus(DWORDLONG start,DWORDLONG end)=0;
	virtual void Union(DWORDLONG start,DWORDLONG end)=0;
	virtual Symbol* Intersection(DWORDLONG start,DWORDLONG end) const =0;

	virtual BOOL Contains(DWORDLONG address) const =0;

	virtual DWORDLONG MappedSize(DWORDLONG start=0,DWORDLONG end=-1) const =0;
	virtual void MappedBlocks(DWORDLONG start,DWORD size,DWORD *pBuffer,DWORD cnt) const =0;
};
