/***************************
	wintruder plugin sample FunctionBreakpoints
	copyright future vision - all rights reserved
***************************/
#pragma once

#include "UserSymbol.h"
#define _USER_SYMBOL
#include "Breakpoint.h"
#undef _USER_SYMBOL

/*! @defgroup BPCB_xxx function breakpoint callback reason*/
//@{
#define BPFNC_ENTER			0	//!< function have been entered
#define BPFNC_RETURN		1	//!< return from function
#define BPFNC_ERROR			2	//!< error on function entry
#define BPFNC_SUSPICIOUS	3	//!< suspicious stack frame on function entry
#define BPFNC_REMOVE		-1	//!< callback is beeing removed (pThread==NULL)
//@}

class Thread;
class Breakpoint;

/*!	@brief prototype of BreakpointX86Function callback
	@param pThread thread in whose context the breakpoint occurred, or NULL on final callback
	@param pBreakpoint the breakpoint that occurred
	@param pCallbackCookie cookie
	@param nReason reason for calling callback function, a value of @ref BPFNC_xxx "BPFNC_xxx"
	@returns a value of @ref BPCB_xxx "BPCB_xxx"
	@remarks if @em pThread==NULL the callback function is beeing removed from the breakpoint
		or the breakpoint is killed, @em pCallbackCookie should be uninitialized
	@sa Breakpoint::SetCallback()
*/
typedef int (*pBreakpointX86FunctionCb)(Thread *pThread,Breakpoint* pBreakpoint,void *pCallbackCookie,int nReason);

/*************
	BreakpointListX86Function
*************/
class BreakpointListX86Function : public BreakpointList
{
public:
/*************
	introducing virtual
*************/
/*************
	inherited
*************/
//symbol
	virtual DWORDLONG Identifer() const;
	virtual LPCSTR Name();
	virtual LPCSTR Type();
	virtual BOOL AddChild(Symbol *pSymbol);
	virtual BOOL RemoveChild(Symbol *pSymbol);
//breakpoint
	virtual DWORD BreakFlags() const;
	virtual Symbol *ChildById(DWORD id);
	virtual Symbol *Create(DWORDLONG Address,BOOL bPermanent,DWORD nSkip,LPCSTR sCondition,int nDebug,BPLogData *pLogData);
	/*!	@brief create BreakpointX86Function and initialize callback function
		@sa CreateEx_BP_X86FNC()
	*/
	virtual Symbol *CreateEx(DWORDLONG Address,...);
	virtual HICON Icon();
/*************
	other
*************/
//ctor,dtor
	BreakpointListX86Function(Symbol *pParent);
	~BreakpointListX86Function();
private:
/*************
	data
*************/
	DWORD m_nId;
};

/*************
	BreakpointX86Function
*************/
class BreakpointX86Function : public Breakpoint
{
public:
/*************
	introducing virtual
*************/
	virtual BOOL SetCallbackEx(pBreakpointX86FunctionCb pCallback,void* pCallbackCookie,LPCSTR pszDescription=NULL);
	virtual pBreakpointX86FunctionCb GetCallbackEx(LPVOID &pCallbackCookie);
/*************
	interited
*************/
//breakpoint
	virtual DWORD BreakFlags() const;
	virtual DWORD Id();

	virtual BOOL Skip();

	virtual BOOL Kill();

	virtual BOOL Enable();
	virtual BOOL Disable();

	virtual BOOL IsEnabled();

	virtual void SetLog(BPLogData *pLogData);
	virtual BPLogData* GetLog();

	virtual void SetPermanent(BOOL bPermanent);
	virtual BOOL GetPermanent();

	virtual void SetCondition(LPCSTR sCondition,DWORD nDebug);
	virtual LPCSTR GetCondition(DWORD &nDebug);

	virtual void SetSkipCount(DWORD nSkip);
	virtual DWORD GetSkipCount(DWORD &nCurSkip);

	virtual BOOL SetCallback(pBreakpointCb pCallback,void* pCallbackCookie,LPCSTR pszDescription=NULL);
	virtual pBreakpointCb GetCallback(LPVOID &pCallbackCookie);
//symbol
	virtual DWORDLONG Identifer() const;
	virtual LPCSTR Name();
	virtual LPCSTR Type();
	virtual LPCSTR Description();
	virtual DWORDLONG VA(Process *p_pt);
	virtual DWORDLONG Size();
/*************
	other
*************/
//ctor,dtor
	BreakpointX86Function(Symbol *pParent,DWORD nId,DWORDLONG nAddress);
	~BreakpointX86Function();

private:
	int OnBreakpointX68(Thread *pThread,Breakpoint* pBreakpoint);
	int OnBreakpointIndirect(Thread *pThread,Breakpoint* pBreakpoint);
	int OnBreakpoint(Thread *pThread,int nReason);
	static int BreakpointX68Cb(Thread *pThread,Breakpoint* pBreakpoint,void* pCookie);
	static int BreakpointIndirectCb(Thread *pThread,Breakpoint* pBreakpoint,void* pCookie);
/*************
	data
*************/
	DWORDLONG m_nAddress;
	DWORD m_nId;

	BOOL m_bPermanent;
	DWORD m_nSkipCount;

	LPSTR m_pszCondition;
	DWORD m_nDebug;

	pBreakpointX86FunctionCb m_pCallback;
	void *m_pCallbackCookie;
	LPSTR m_pszDescription;

	Breakpoint *m_pBreakpointX86;
};

//for documentation only
Symbol *CreateEx_BP_X86FNC(DWORDLONG Address,pBreakpointX86FunctionCb pCallback,void *pCallbackCookie,LPCSTR pszDescription);
