/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

/*! @brief %Section of Module

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_SECTION, 0)
*/
class Section : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get section index
		@returns section index
		@remarks if the high bit of the return value is set, i.e. (int)Index()<0, the section defines additional data
	*/
	virtual DWORD Index() const=0;
	/*!	@brief get section characteristics
		@returns a combination of IMAGE_SCN_xxx values as defined in winnt.h
	*/
	virtual DWORD Spec() const =0;
};

/*! @brief list of Section

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_SECTIONLIST, 0)
*/
class SectionList : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get a Section by index
		@param idx section index
		@returns Section of index @em idx
	*/	
	virtual Symbol* ChildByIndex(DWORD idx);
};
