/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once



#define MAKEDWORDLONG(lo,hi)	( (DWORDLONG) ( ( ((DWORDLONG)hi) << 32 ) | ((DWORDLONG)lo) ) )
#define LOWDWORD(x)				( (DWORD)( (x) & 0xffffffff ) )
#define HIDWORD(x)				( (DWORD)( ((x)>>32) & 0xffffffff ) )


/******************
	additional resource types
******************/
#ifndef RT_MANIFEST
	#define RT_MANIFEST 24 
#endif

#define RT_DFM 50
#define RT_TYPELIB 0x1d08

/*!	pid of wintruders virtual process*/
#define PID_WINTRUDER	0x80000000


#define SYMDBG_TYPE(x) ((x)&0xffff)
#define SYMDBG_CREATOR(x) (((x)>>16)&0xffff)
#define SYMDBG_MAKETYPE(type,creator) ( ((DWORD)(creator)<<16) | (type) )

/*! @defgroup CREATOR_xxx Debug information creator */
//@{
#define CREATOR_NONE		0

#define CREATOR_ANALYZER	1

#define CREATOR_EXPORTS		10
#define CREATOR_METADATA	11
#define CREATOR_TYPELIB		12
#define CREATOR_VB			13

#define CREATOR_MAPFILE		20
#define CREATOR_DIA			21
#define CREATOR_DIAPUBLIC	22
#define CREATOR_BORLAND		23

#define CREATOR_MIRROR		25
#define CREATOR_WKT			26
//@}	//CREATOR_xxx



/*! @defgroup SYM_IDENTIFER Symbol identifer*/
//@{

/*! create %Identifer() from @ref SYMID_xxx and @ref SYMSUBID_xxx
	@param type Symbol main type
	@param subtype Symbol sub type
	@returns Identifer()
*/
#define SYM_MAKEID(type,subtype) MAKEDWORDLONG(subtype,type)
/*! extract @ref SYMID_xxx from Symbol::Identifer()
	@param x Symbol::Identifer()
	@returns @ref SYMID_xxx
*/
#define SYM_ID(x) HIDWORD(x)
/*! extract @ref SYMSUBID_xxx from Symbol::Identifer()
	@param x Symbol::Identifer()
	@returns @ref SYMSUBID_xxx
*/
#define SYM_SUBID(x) LOWDWORD(x)




/********************

	main types

********************/
/*! @defgroup SYMID_xxx Symbol main types */
//@{
/********************
	root symbol
********************/
/*! Wintruder root Symbol returned by GetRootSymbol()*/
#define SYMID_ROOT 1


#define SYMID_LIST 2

#define SYMID_PROJECT 3

#define SYMID_SYNCSTATE 4
/********************
	debug items
********************/
/*! StartupInfoList */
#define SYMID_STARTUPINFOLIST 8
/*! StartupInfo */
#define SYMID_STARTUPINFO 9

/*! ProcessList*/
#define SYMID_PROCESSLIST 10
/*! Process*/
#define SYMID_PROCESS 11

/*! ThreadList*/
#define SYMID_THREADLIST 12	
/*! Thread*/
#define SYMID_THREAD 13	

/*! ModuleList*/
#define SYMID_MODULELIST 14	
/*! Module*/
#define SYMID_MODULE 15	

/*! FrameArray*/
#define SYMID_FRAMEARRAY 16	
/*! Frame*/
#define SYMID_FRAME 17	

/*! InterfaceList */
#define SYMID_LINKLIST 18
/*!	InterfaceLink*/
#define SYMID_INTERFACELINK	19
/*! DebugLink*/
#define SYMID_DEBUGLINK 20

/*! DebugEventList*/
#define SYMID_DEBUGEVENTLIST 21
/*! DebugEvent*/
#define SYMID_DEBUGEVENT 22
/********************
	moduleinfo
********************/
/*! ModuleInfoList*/
#define SYMID_MODULEINFOLIST 25
/*! ModuleInfo*/
#define SYMID_MODULEINFO 26
/*! ModuleInfoRefList*/
#define SYMID_MODULEINFOREFLIST 27

//moduleinfo items
#define SYMID_HEAPLIST 30
#define SYMID_HEAP 31
#define SYMID_HEAPENTRY 32

/*! list of Page symbols*/
#define SYMID_PAGELIST 33	
/*! Page*/
#define SYMID_PAGE 34	

/*! SectionList*/
#define SYMID_SECTIONLIST 35	
/*! Section*/
#define SYMID_SECTION 36	

#define SYMID_IMPORTLIST 37
#define SYMID_IMPORTMODULE 38
#define SYMID_IMPORT 39

/*! ExportList*/
#define SYMID_EXPORTLIST 40
/*! Export*/
#define SYMID_EXPORT 41

/*! ExportList*/
#define SYMID_EXPORTFOREWARDLIST 42
/*! ExportForeward*/
#define SYMID_EXPORTFOREWARD 43

#define SYMID_RESOURCELIST 44
#define SYMID_RESOURCEITEMLIST 45
#define SYMID_RESOURCE 46

/*!	RelocationList*/
#define SYMID_RELOCATIONLIST 47
/*	Relocation*/
#define SYMID_RELOCATION 48

/*! list of XReference symbols*/
#define SYMID_XREFDATA 49	
/*! XReference*/
#define SYMID_XREFERENCE 50	
#define SYMID_XREFITEM 51
#define SYMID_XREFREFERENCE 52

#define SYMID_XREFRANGEARRAY 53
/*! XRefHintList*/
#define SYMID_XREFHINTLIST 54	
/*! XRefHint*/
#define SYMID_XREFHINT 55	

#define SYMID_VBLIST 56
#define SYMID_VBOBJECT 57

#define SYMID_METADATALIST 58
#define SYMID_METADATA 59
#define SYMID_METADATARESOURCE 60

#define SYMID_SYMBOLDATA 61
/*! WintruderDbgFile*/
#define SYMID_DBGFILE 62	
#define SYMID_SRCFILE 63

/*! EntryPointList*/
#define SYMID_ENTRYPOINTLIST 64
/*! EntryPoint*/
#define SYMID_ENTRYPOINT 65

/*! NamesList*/
#define SYMID_NAMESLIST 66
/*! Names*/
#define SYMID_NAMES 67

#define SYMID_SYMBOL 80
#define SYMID_TYPE 81
#define SYMID_SOURCE 82
#define SYMID_SOURCEITEM 83

/********************
	components
********************/
/*! InterfaceList*/
#define SYMID_INTERFACELIST 100
/*! InitInterfaceList*/
#define SYMID_INITINTERFACELIST 101
/*! Interface*/
#define SYMID_INTERFACE 102

/*! DebugList*/
#define SYMID_DEBUGLIST 103
/*! Debug*/
#define SYMID_DEBUG 104

/*! DisasmList*/
#define SYMID_DISASMLIST 105
/*! Disasm*/
#define SYMID_DISASM 106

/*! SymbolLoaderList*/
#define SYMID_SYMLOADERLIST 107
/*! SymbolLoader*/
#define SYMID_SYMLOADER 108

/*! PlugInList*/
#define SYMID_PLUGINLIST 109
/*! PlugIn*/
#define SYMID_PLUGIN 110

/*! ToolBox*/
#define SYMID_TOOLBOX 111
/*! Tool*/
#define SYMID_TOOL 112

/*! LogList*/
#define SYMID_LOGLIST 113
/*! Log*/
#define SYMID_LOG 114

/*! BookmarkList*/
#define SYMID_BOOKMARKLIST 115
/*! BookmarkProcess*/
#define SYMID_BOOKMARKPROCESS 116
/*! Bookmark*/
#define SYMID_BOOKMARK 117

/*! ConfigList*/
#define SYMID_CONFIGLIST 118
/*! ConfigNode*/
#define SYMID_CONFIG 119

/*!	Parser*/
#define SYMID_PARSER 120
/*!	ParserResult*/
#define SYMID_PARSERRESULT 121
/********************
	ranges
********************/
#define SYMID_EMPTYRANGE 150
#define SYMID_RANGE 151
#define SYMID_RANGEARRAY 152

/********************
	breakpoint
********************/
#define SYMID_BREAKPOINTLIST 153
#define SYMID_BREAKPOINT 154

/********************
	patches
********************/
#define SYMID_PATCHLIST 155
#define SYMID_PATCH 156

/********************
	exceptions
********************/
/*! ExceptionList*/
#define SYMID_EXCEPTIONLIST 200
/*! Exception */
#define SYMID_EXCEPTION 201

/********************
	gui
********************/
#define SYMID_PROGRESSINDICATOR 300


//@}	//SYMID_xxx
/********************

	sub types

********************/
//! @defgroup SYMSUBID_xxx Symbol sub types
//@{

//process types
/*! @defgroup STARTUP_xxx StartupInfo sub types */
//@{
#define STARTUP_START	0
#define STARTUP_ATTACH	1
#define STARTUP_INHERIT	2
//@}	//STARTUP_xxx

//process types
/*! @defgroup PROC_xxx Process sub types */
//@{
#define PROC_TERMINATED	0
#define PROC_PROCESS	1

#define PROC_DUMP		5
#define PROC_FILE		6
#define PROC_DEVICE		7
#define PROC_IMAGE		8

#define PROC_WINTRUDER	0xff
//@}	//PROC_xxx

//import types
/*! @defgroup IMPORT_xxx Imports sub types */
//@{
#define IMPORT_STD	0
#define IMPORT_DELAYED 1
#define IMPORT_DYNAMIC 2
//@}	//IMPORT_xxx

//meta data list types
/*! @defgroup META_xxx Metadata sub types */
//@{
#define META_LIST 0
#define META_ASSEMBLYREF 1
#define META_MODULEREF 2
#define META_FILE 3
#define META_RESOURCE 4
//meta data resource types
#define META_RES_FORM 0
#define META_RES_CONTROL 1
//@}	//META_xxx


//vb objects
/*! @defgroup VB_xxx VisualBasic sub types */
//@{
#define VBL_PROJECT 0
#define VBL_OBJECT 1
#define VBL_COMPONENT 2
#define VBL_GUIOBJECT 3

#define VB_FORM 0
#define VB_MODULE 1
#define VB_CLASS 2
#define VB_USERCONTROL 3
#define VB_PROPERTYPAGE 4
#define VB_UNKNOWN 5

#define VB_CONTROL 20

#define VB_COMPONENT 21
#define VB_GUIOBJECT 22
//@}	//VB_xxx

/*! @defgroup MI_ ModuleInfo sub types*/
//@{
/*! create @ref SYM_SUBID of ModuleInfo::Identifer() from @ref MI_xxx and @ref PC_xxx
	@param mi image type. predefined values are @ref MI_xxx "MI_xxx"
	@param pc processor type. predefined values are @ref PC_xxx "PC_xxx"
	@returns SYM_SUBID of ModuleInfo
*/
#define MAKE_MI(mi,pc) ((pc<<16)|mi)
/*! extract @ref MI_xxx from @ref SYM_SUBID of ModuleInfo::Identifer()
	@param x SYM_SUBID of ModuleInfo
	@returns @ref MI_xxx
*/
#define GET_MI(x) (x&0xffff)
/*! extract @ref PC_xxx from @ref SYM_SUBID of ModuleInfo::Identifer()
	@param x SYM_SUBID of ModuleInfo
	@returns @ref PC_xxx
*/
#define GET_PC(x) ((x>>16)&0xffff)

//moduleinfo types	lowword of moduleinfo subtype
/*! @defgroup MI_xxx ModuleInfo image type*/
//@{
#define MI_None			0
#define MI_MZ			10
#define MI_NE			20
#define MI_LE			30
#define MI_PE			40
//@}	//MI_xxx
//processor types	highword of moduleinfo subtype
/*! @defgroup PC_xxx ModuleInfo processor type*/
//@{
#define PC_None			0
#define PC_I286			1
#define PC_I386			2
#define PC_I64			3
#define PC_IA64			4
//@}	//PC_xxx
//@}	//MI_

//breakpointlist and breakpoint subtypes
/*! @defgroup BP_xxx Breakpoint sub types */
//@{
#define BP_X86STEP		0
#define BP_X86HW		1
#define BP_X86			2
#define BP_X86ICEBP		3
#define BP_X86INDIRECT	4
#define BP_X86VTABLE	5
#define BP_X86INTERFACE	6
#define BP_X86PAGEGUARD	7
#define BP_VBSTEP		10
#define BP_VB			11
#define BP_CLRSTEP		20
#define BP_CLR			21
#define BP_SCRIPTSTEP	40
#define BP_SCRIPT		41
#define BP_INTERPRETERSTEP 0xf0
#define BP_INTERPRETER	0xf1

#define BP_USER			0x100	//! @todo BP_USER used for additional properties @sa SetBreakpoint::SetAddress
//@}	//BP_xxx

//relocataion subtypes
/*! @defgroup RELOC_xxx Relocation sub types */
//@{
#define	RELOC_NONE		0
#define RELOC_SEGMENT16	1
#define RELOC_OFFSET32	2
#define RELOC_OFFSET64	3
//@}	//RELOC_xxx

//debug subtypes
/*! @defgroup DEBUG_xxx Debugger sub types */
//@{
#define DEBUG_NONE		((DWORD)-1)
#define DEBUG_X86		0
#define DEBUG_CLRNATIVE	1
#define DEBUG_CLRCIL	2
#define DEBUG_VB		3
#define DEBUG_VDM		4
#define DEBUG_JAVA		5
#define DEBUG_SCRIPT	6
#define DEBUG_INTERPRETER 30
//@}	//DEBUG_xxx

//disasm subtypes
/*! @defgroup DISASM_xxx Disassembler sub types */
//@{
#define	DISASM_X86		0
#define DISASM_VB		1
#define DISASM_CIL		2
#define DISASM_JAVA		3
//@}	//DISASM_xxx

//xreference subtypes	highword of xreference subtypes
/*! @defgroup XREF_xxx Cross reference sub types */
//@{
#define XREF_RVA		0
#define XREF_INT16		1
#define XREF_INT32		2
#define XREF_INT64		3
#define XREF_TOKEN		4
#define XREF_FLT8		5

#define XREF_MAX		6
//@}	//XREF_xxx

//reference subtypes
/*! @defgroup REF_xxx Reference sub types */
//@{
#define REF_IMMEDIATE	0
	//flow refs
#define REF_CALL		1
#define REF_CONDITIONAL	2
#define REF_UNCONDITIONAL 3
#define REF_RETURN		4

#define REF_DISPLACEMENT 5
#define REF_ABSOLUTE	6

#define REF_DATA		7
	//some values
#define REF_MAX			8
#define REF_NONE		0xff
#define REF_FLOW_FIRST	REF_CALL
#define REF_FLOW_LAST	REF_RETURN
//@}	//REF_xxx

//xreference known ranges
/*! @defgroup RANGE_xxx Range sub types */
//@{
#define RANGE_CODE		0
#define RANGE_DATA		1
#define RANGE_LIBRARY	2
//@}	//RANGE_xxx

//predefined entry point types
/*! @defgroup EP_xxx EntryPoint sub types */
//@{
#define EP_OTHER		0
#define EP_MODULE		1
#define EP_DLL			2
#define EP_TLS			3
//@}	//EP_xxx

//basic tools
/*! @defgroup TOOL_xxx Tools sub types */
//@{
#define TOOL_DIRCONTAINER		0
#define TOOL_WINERRORCODES		1
#define TOOL_FILELOCATOR		2
#define TOOL_FILEFORMAT			3
#define TOOL_REGULAREXPRESSION	4
#define TOOL_EXTERNALLIST		5
#define TOOL_EXTERNAL			6

#define TOOL_USER				1000
//@}	//TOOL_xxx

//basic interfaces
/*! @defgroup INTERFACE_xxx Interface sub types */
//@{
#define INTERFACE_NONE		((DWORD)-1)
#define INTERFACE_BASIC		0
#define INTERFACE_WIN32		1
#define INTERFACE_CLR		2
#define INTERFACE_CLR_MANAGED	3
#define INTERFACE_CLR_UNMANAGED	4
#define INTERFACE_STEALTH	5
#define INTERFACE_SCRIPT	6
#define INTERFACE_FILE		10
//@}	//INTERFACE_xxx

//config nodes
/*! @defgroup CONFIG_xxx Configuration sub types */
//@{
#define CONFIG_NODE		0
#define CONFIG_ELEMENT	1
#define CONFIG_ATTRIBUTE	2
#define CONFIG_COMMENT	3
#define CONFIG_FILE		4
#define CONFIG_ROOT		5
//@}	//CONFIG_xxx
//@}	//SYMSUBID_xxx
//@}	//SYM_IDENTIFER

/******************
	index types
******************/
#define SYM_INDEX_SYMID			(1<<0)
#define SYM_INDEX_NAME			(1<<1)
#define SYM_INDEX_RVA			(1<<2)
#define SYM_INDEX_VA			(1<<3)
#define SYM_INDEX_SIZE			(1<<4)
#define SYM_INDEX_USER			(1<<16)

/******************
	symbol loader mask
******************/
/*! @defgroup SL_xxx Symbol loader mask
	@brief loader flags used by SymbolLoader::LoadInformation() and ModuleInfo::LoadInformation()
*/
//@{
/*! indentify ModuleInfo symbol. i.e. sets the @ref MI_*/
#define SL_IDENTIFY				0

/*!	load @ref SYMID_SECTIONLIST*/
#define SL_SECTION				1
/*!	load @ref SYMID_ENTRYPOINTLIST*/
#define SL_ENTRY				2
/*! load @ref SYMID_RESOURCELIST*/
#define SL_RESOURCE				3
/*! load @ref SYMID_EXPORTLIST and @ref SYMID_EXPORTFOREWARDLIST*/
#define SL_EXPORT				4
/*! load @ref SYMID_IMPORTLIST*/
#define SL_IMPORT				5
/*! load all other additional information*/
#define SL_OTHER				6
/*! load @ref SYMID_RELOCATIONLIST*/
#define SL_RELOCATION			7

/*! load @ref SYMID_DBGFILE and @ref SYMID_SRCFILE*/
#define SL_DEBUG				16
/*! load @ref SYMID_XREFDATA*/
#define SL_XREF					20

#define SL_MULTIPLE				((1<<SL_IDENTIFY)|(1<<SL_OTHER)|(1<<SL_DEBUG)|(1<<SL_XREF)|(1<<SL_ENTRY))
//@}	//SL_xxx