/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once


/*************
	SymbolLoader
*************/
#ifdef _USER_SYMBOL
	#include "UserSymbol.h"
	#define _BASE_CLASS UserSymbol
#else
	#include "symbol.h"
	#define _BASE_CLASS Symbol
#endif
/*!	@brief loader for collecting ModuleInfo information

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_SYMLOADER, @ref SYM_LOADER_xxx)
*/
class SymbolLoader : public _BASE_CLASS
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief load ModuleInfo information

		Wintruder calls this member function to retrieve information about a ModuleInfo symbol.
		the loader creates the requested information and uses AddChild() to add them to 
		the ModuleInfo symbol.
		@param pModuleInfo pointer to a ModuleInfo symbol
		@param info specifies the information to be retrieved. a value of @ref SL_xxx "SL_xxx"
		values.
		@returns nonezero if information added to @em pModuleInfo
		@sa ModuleInfo::LoadInformation()
	*/
	virtual BOOL LoadInformation(Symbol *pModuleInfo,DWORD info)=0;
/*************
	constructor
*************/
#ifdef _USER_SYMBOL
	SymbolLoader(Symbol *pParent):_BASE_CLASS(pParent){}
#endif
};
#undef _BASE_CLASS


/*************
	SymbolLoaderList
*************/
/*!	@brief list of SymbolLoader

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_SYMLOADERLIST, 0)
*/
class SymbolLoaderList : public Symbol
{
public:
/*************
	introducing virtual
*************/
};
