/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

typedef BOOL(*pAbortCb)(void *pCookie);

class Breakpoint;
/*! @brief synchronization of messages and wait states

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_SYNCSTATE, 0)
*/
class SyncState : public Symbol
{
public:
/*************
	introducing virtual
*************/
//messages
	/*! @brief %Broadcast asynchronous message
		@param type of broadcast, a value of @ref BROADCAST_xxx "BROADCAST_xxx"
		@param message message to be sent
		@returns return value currently unused, return zero
		@see Broadcast.doc
	*/
	virtual LRESULT Broadcast(int type,WPARAM message,...);

//busy action dialog
	virtual POSITION BusyAddAction(LPCSTR sAction);
	virtual void BusyRemoveAction(POSITION pos);

//multi action manager
	virtual BOOL MultiIsBusy(DWORD nCookie=0);
	virtual DWORD MultiStart(DWORD nCookie,DWORD nSeq);
	virtual BOOL MultiStop(DWORD nCookie);

//generic waiting dialog
	virtual BOOL WaitIsBusy();
	virtual BOOL WaitStart(DWORD nAfter,LPCSTR pszText,BOOL bBlock,pAbortCb pAbort,void *pCookie=NULL);
	virtual BOOL WaitStop(DWORD nAfter);

//loader
	/*!	@brief check whether any SymbolLoader is running
		@returns nonezero if SymbolLoader is loading information
	*/
	virtual BOOL SymbolLoaderIsBusy();

//abort thread
	/*!	@brief check if thread to be aborted
		@returns nonezero if the current thread is about to be aborted
		@remarks usually called from any Loader function
		@remarks if this check returns nonezero, abort the current (time expensive) operation 
		in a clean manner and return to caller
	*/
	virtual BOOL AbortCheck();
};