#include "StdAfx.h"
#include "UserSymbol.h"

#ifndef ASSERT
	#include "assert.h"
#endif


extern volatile LONG g_nReferenceCount;



//implement the Symbol destructor
Symbol::~Symbol()
{
}


UserSymbol::UserSymbol(Symbol* pParent)
{
	InterlockedIncrement(&g_nReferenceCount);
	m_nRefCount=1;
	m_pParent=pParent;
	m_bDeleting=false;
}

UserSymbol::~UserSymbol()
{
#ifdef _DEBUG
	m_nRefCount=0x22222222;
#endif
}


ULONG UserSymbol::AddRef()
{
	InterlockedIncrement(&g_nReferenceCount);

	LONG ref=InterlockedIncrement(&m_nRefCount);
	ASSERT(ref>0&&ref<0x10000000);
	return ref;
}
ULONG UserSymbol::Release()
{
	InterlockedDecrement(&g_nReferenceCount);

	LONG ref=InterlockedDecrement(&m_nRefCount);
	ASSERT(ref>=0&&ref<0x10000000);
	if(!ref&&!m_bDeleting)
	{
		m_bDeleting=true;
		delete this;
	}
	return ref;
}
ULONG UserSymbol::ReleaseEx(Symbol *pSym)
{
	ASSERT(pSym);
	LONG ref=Release();
	if(ref&&pSym==m_pParent)
		m_pParent=NULL;
	return ref;
}

Symbol* UserSymbol::Parent() const
{
	if(m_pParent)
		m_pParent->AddRef();
	return m_pParent;
}


LPCSTR UserSymbol::Name()
{
	return NULL;
}

LPCSTR UserSymbol::Type()
{
	return NULL;
}

LPCSTR UserSymbol::Description()
{
	return NULL;
}


DWORD UserSymbol::RVA()
{
	return -1;
}

DWORDLONG UserSymbol::Size()
{
	return -1;
}

DWORD UserSymbol::RVAEnd()
{
	DWORDLONG size=Size();
	if(!HIDWORD(size))
	{
		if(size)
			size--;

		DWORD start=RVA();
		if(start!=-1)
		{
			size+=start;
			if(!HIDWORD(size))
				return (DWORD)size;
		}
	}
	return -1;
}

BOOL UserSymbol::RVARange(DWORD &start, DWORD &end)
{
	return	(start=RVA())!=-1&&
			(end=RVAEnd())!=-1;
}

DWORDLONG UserSymbol::VA(Process* p_pt)
{
	return -1;
}

DWORDLONG UserSymbol::VAEnd(Process* p_pt)
{
	DWORDLONG size=Size();
	if(size==-1)
		return -1;
	return VA(p_pt)+size-1;
}
BOOL UserSymbol::VARange(DWORDLONG &start,DWORDLONG &end,Process* p_pt)
{
	if(	(start=VA(p_pt))!=-1&&
		(end=VAEnd(p_pt))!=-1)
		return TRUE;
	return FALSE;
}


BOOL UserSymbol::HasChildren() const
{
	return const_cast<UserSymbol*>(this)->FirstChildPosition()!=NULL;
}

int UserSymbol::ChildrenCount() const
{
	ASSERT(FALSE);
	return 0;
}
BOOL UserSymbol::AddChild(Symbol* pSymbol)
{
	ASSERT(FALSE);
	return FALSE;
}
BOOL UserSymbol::RemoveChild(Symbol* pSym)
{
	ASSERT(FALSE);
	return FALSE;
}
POSITION UserSymbol::FirstChildPosition()
{
	return NULL;
}
Symbol* UserSymbol::NextChild(POSITION &pos)
{
	ASSERT(FALSE);
	pos=NULL;
	return NULL;
}





Symbol* UserSymbol::ChildByRVA(DWORD address)
{
	return NULL;
}

BOOL UserSymbol::BoundsRVA(DWORD address)
{
	DWORD t=RVA();
	if(t!=-1&&address>=t)
	{
		t=RVAEnd();
		if(t!=-1&&address<=t)
			return TRUE;
	}
	return FALSE;
}




Symbol* UserSymbol::ChildByVA(DWORDLONG address,Process* p_pt)
{
	return NULL;
}

BOOL UserSymbol::BoundsVA(DWORDLONG address,Process* p_pt)
{
	DWORDLONG t=VA(p_pt);
	if(t!=-1&&address>=t)
	{
		t=VAEnd(p_pt);
		if(t!=-1&&address<=t)
			return TRUE;
	}
	return FALSE;
}

Symbol* UserSymbol::ChildByIdentifer(DWORDLONG symId)
{
	return NULL;
}
Symbol* UserSymbol::ChildByName(LPCSTR name)
{
	return NULL;
}

Symbol* UserSymbol::ChildRangeByVA(DWORDLONG Address,Process* p_pt)
{
	ASSERT(FALSE);
	return NULL;
}
Symbol* UserSymbol::ChildRangeByRVA(DWORD Address)
{
	ASSERT(FALSE);
	return NULL;
}

/************
	export functions
************/


void UserSymbol::ExportList(Process* p_pt,LPCSTR *arFormat,int nFormat)
{
	if(nFormat)
		*arFormat=NULL;
}

BOOL UserSymbol::Export(Process* p_pt,LPCSTR pszFormat,LPCSTR pszFileName)
{
	return FALSE;
}

CPropertyPage* UserSymbol::Property(DWORD dwThreadId)
{
	return NULL;
}



/*************
	UserSymbolBackRef
*************/
UserSymbolBackRef::UserSymbolBackRef(Symbol *pParent)
	:UserSymbol(pParent)
{
	if(pParent)
		pParent->AddRef();
}
ULONG UserSymbolBackRef::Release()
{
	LONG ref=InterlockedExchangeAdd(&m_nRefCount,0);
	ASSERT(ref>=1&&ref<0x10000000);

	if(ref==1&&!m_bDeleting&&m_pParent)
		m_pParent->ReleaseEx(this);
	return UserSymbol::Release();
}

ULONG UserSymbolBackRef::ReleaseEx(Symbol *pSym)
{
	ASSERT(pSym);
	if(pSym==m_pParent)
		m_pParent=NULL;
	return UserSymbol::ReleaseEx(pSym);
}

/*************
	UserSymbolList
*************/
UserSymbolList::UserSymbolList(Symbol *pParent)
	:UserSymbol(pParent)
{
	m_pHead=NULL;
	m_pTail=NULL;
	m_nCount=0;
}
UserSymbolList::~UserSymbolList()
{
	ResetChildren();
}
BOOL UserSymbolList::HasChildren() const
{
	return m_nCount==0;
}
int UserSymbolList::ChildrenCount() const
{
	return m_nCount;
}
BOOL UserSymbolList::AddChild(Symbol *pSymbol)
{
	ASSERT(pSymbol);
	if(pSymbol)
	{
		_tag_List *pList=new _tag_List;
		pList->pNext=NULL;
		pList->pSymbol=pSymbol;
		pSymbol->AddRef();
		if(m_pTail)
			m_pTail->pNext=pList;
		else
			m_pHead=pList;
		m_pTail=pList;
		return TRUE;
	}
	return FALSE;
}
BOOL UserSymbolList::RemoveChild(Symbol *pSymbol)
{
	ASSERT(pSymbol);
	if(pSymbol)
	{
		_tag_List *pPrev=NULL;
		_tag_List *pList=m_pHead;
		while(pList)
		{
			if(pList->pSymbol==pSymbol)
			{
				if(pPrev)
					pPrev->pNext=pList->pNext;
				else
					m_pHead=pList->pNext;
				if(pList==m_pTail)
					m_pTail=pPrev;
				pList->pSymbol->ReleaseEx(this);
				delete pList;
				return TRUE;
			}
			pPrev=pList;
			pList=pList->pNext;
		}
	}
	return FALSE;
}
POSITION UserSymbolList::FirstChildPosition()
{
	return (POSITION)m_pHead;
}
Symbol *UserSymbolList::NextChild(POSITION &pos)
{
	_tag_List *pList=(_tag_List*)pos;
	ASSERT(pList);
	Symbol* pSymbol=pList->pSymbol;
	pos=(POSITION)pList->pNext;
	pSymbol->AddRef();
	return pSymbol;
}
Symbol *UserSymbolList::ChildByVA(DWORDLONG address,Process *p_pt)
{
	SymbolPtr<Symbol> pSymbol;
	POSITION pos=FirstChildPosition();
	while(pos)
	{
		pSymbol=NextChild(pos);
		if(pSymbol->BoundsVA(address,p_pt))
			return pSymbol.AddRef();
	}
	return NULL;
}
Symbol *UserSymbolList::ChildByRVA(DWORD address)
{
	SymbolPtr<Symbol> pSymbol;
	POSITION pos=FirstChildPosition();
	while(pos)
	{
		pSymbol=NextChild(pos);
		if(pSymbol->BoundsRVA(address))
			return pSymbol.AddRef();
	}
	return NULL;
}

void UserSymbolList::ResetChildren()
{
	while(m_pHead)
	//unsafe symbol parameter usage!
		RemoveChild(m_pHead->pSymbol);
}