/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

class UserSymbol : public Symbol
{
	friend class UserSymbolBackRef;
public:
/****************
	virtual
****************/
//destructor
	virtual ~UserSymbol();

//reference counting
	virtual ULONG __stdcall AddRef();
	virtual ULONG __stdcall Release();
	virtual ULONG ReleaseEx(Symbol *pSym);
//identifer
//	virtual DWORDLONG Identifer() const =0;
//informational
	virtual LPCSTR Name();
	virtual LPCSTR Type();
	virtual LPCSTR Description();
//relatives
	virtual Symbol* Parent() const;

	virtual BOOL HasChildren() const;
	virtual int ChildrenCount() const;

	virtual BOOL AddChild(Symbol *pSymbol);
	virtual BOOL RemoveChild(Symbol *pSymbol);

	virtual POSITION FirstChildPosition();
	virtual Symbol* NextChild(POSITION &pos);
//size
	virtual DWORDLONG Size();
//address
	virtual DWORDLONG VA(Process *p_pt);
	virtual DWORDLONG VAEnd(Process *p_pt);
	virtual BOOL VARange(DWORDLONG &start,DWORDLONG &end,Process *p_pt);
	virtual BOOL BoundsVA(DWORDLONG address,Process *p_pt);

	virtual DWORD RVA();
	virtual DWORD RVAEnd();
	virtual BOOL RVARange(DWORD &start,DWORD &end);
	virtual BOOL BoundsRVA(DWORD address);
//query children 
	virtual Symbol* ChildByIdentifer(DWORDLONG id);
	virtual Symbol* ChildByName(LPCSTR name);

	virtual Symbol* ChildByVA(DWORDLONG address,Process *p_pt);
	virtual Symbol* ChildByRVA(DWORD address);

	virtual Symbol* ChildRangeByVA(DWORDLONG Address,Process *p_pt);
	virtual Symbol* ChildRangeByRVA(DWORD Address);

//symbol export
	virtual BOOL Export(Process *p_pt,LPCSTR pszFormat,LPCSTR pszFileName);
	virtual void ExportList(Process *p_pt,LPCSTR *arFormat,int nFormat);

//todo
	virtual CPropertyPage* Property(DWORD dwThreadId);
/****************
	constructor
****************/
	UserSymbol(Symbol *pParent);
protected:
/*************
	data
*************/
	volatile LONG m_nRefCount;
	Symbol* m_pParent;
	bool m_bDeleting;
};


class UserSymbolBackRef : public UserSymbol
{
public:
/*************
	inherited
*************/
	virtual ULONG __stdcall Release();
	virtual ULONG ReleaseEx(Symbol *pSym);
/*************
	other
*************/
//ctor
	UserSymbolBackRef(Symbol *pParent);
};

class UserSymbolList : public UserSymbol
{
public:
/*************
	inherited
*************/
	virtual BOOL HasChildren() const;
	virtual int ChildrenCount() const;

	virtual BOOL AddChild(Symbol *pSymbol);
	virtual BOOL RemoveChild(Symbol *pSymbol);

	virtual POSITION FirstChildPosition();
	virtual Symbol* NextChild(POSITION &pos);

	virtual Symbol* ChildByVA(DWORDLONG address,Process *p_pt);
	virtual Symbol* ChildByRVA(DWORD address);
/*************
	other
*************/
//ctor
	UserSymbolList(Symbol *pParent);
	~UserSymbolList();

	void ResetChildren();
private:
/*************
	data
*************/
	struct _tag_List
	{
		Symbol *pSymbol;
		_tag_List *pNext;
	};
	_tag_List *m_pHead;
	_tag_List *m_pTail;
	int m_nCount;
};
