/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

class WintruderDbgFile : public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual DWORD ReadType(_sym_type type,LPVOID p,DWORD n);

	virtual DWORD GetUdtList(_sym_type *p,DWORD n);
	virtual DWORD GetGlobalList(_sym_type* p,DWORD n);

	virtual _sym_type GetLabel(_sym_type parent,LPCSTR name);
	virtual _sym_type GetProc(_sym_type parent,LPCSTR name,_sym_type type);
	virtual _sym_type GetData(_sym_type parent,LPCSTR name);
	virtual _sym_type GetBlock(_sym_type parent,LPCSTR name);
	virtual _sym_type GetUDT(_sym_type parent,LPCSTR name);
	virtual _sym_type GetEnum(_sym_type parent,LPCSTR name);
	virtual _sym_type GetTypeDef(_sym_type parent,LPCSTR name);

	virtual _sym_type AddComment(LPCSTR name,_sym_storage *pStorage,LPCSTR comment);
	virtual _sym_type AddArg(LPCSTR name,_sym_storage *pStorage,_sym_type type);
	virtual _sym_type AddArgList(_sym_type *arTypes,UINT nTypes);
//implicit parent
	virtual _sym_type AddLabel(_sym_type parent,LPCSTR name,_sym_storage *pStorage);
	virtual _sym_type AddProc(_sym_type parent,LPCSTR name,_sym_storage *pStorage,_sym_type type,DWORD size,_sym_proc_flags flags,_sym_type chunkData);
	virtual _sym_type AddData(_sym_type parent,LPCSTR name,_sym_storage *pStorage,_sym_type type);
	virtual _sym_type AddBlock(_sym_type parent,LPCSTR name,_sym_storage *pStorage,DWORD size);
	virtual _sym_type AddUDT(_sym_type parent,LPCSTR name,_sym_storage *pStorage,DWORD size,_sym_type vtable,_typ_udt_flags flags);
	virtual _sym_type AddEnum(_sym_type parent,LPCSTR name);
	virtual _sym_type AddTypeDef(_sym_type parent,LPCSTR name,_sym_type type);
//explicitparent
	virtual _sym_type AddCodeBlock(_sym_type parent,DWORD offset,DWORD size,BYTE type);
	virtual _sym_type AddBaseClass(_sym_type parent,_sym_type type,DWORD offset,DWORD index,_typ_baseclass_flags flags);
	virtual _sym_type AddEnumerate(_sym_type parent,LPCSTR name,DWORD value);
//no parent
	virtual _sym_type AddPtr(_sym_type type,BYTE size,_typ_ptr_flags flags);
	virtual _sym_type AddArray(_sym_type type,DWORD base,DWORD limit,_typ_array_flags flags);
	virtual _sym_type AddFunction(_sym_type rettype,_sym_type arglist,_typ_function_flags flags,DWORD thisadjust);
	virtual _sym_type AddVTable(_typ_vtable_flags *arFlags,UINT nFlags);
	virtual _sym_type AddTypeRef(_sym_type scope,LPCSTR name,_sym_storage *pStorage);
	virtual _sym_type AddScope(LPCSTR name,_sym_storage *pStorage,_typ_scope_flags flags);
	virtual _sym_type AddValueType(_sym_type type);
//updates
	virtual BOOL UpdateUDTSize(_sym_type type,DWORD size);
};