/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
/***************************
	important notes:
	- struct member alignment: 1 byte
	- default calling convention: __cdecl
	- character set: ASCII (SBCS)
***************************/
#pragma once

#pragma pack(push,1)

#ifdef __cplusplus
extern "C" {
#endif

/**************************************
	plugin data structure
**************************************/
/*!	@brief plugin descriptor
*/
struct WPI_Data
{
//mandatory
	DWORD	cb;	//!< size of WPI_Data structure

	LPCSTR	pName;	//!< pointer to PlugIn name, must not be NULL
	LPCSTR	pDescription;	//!< pointer to description (optional)
	LPCSTR	pCopyRightNote;	//!< pointer to copy right note (optional)
	
	DWORD	Version;	//!<PlugIn version

	DWORD	Flags;	//!< PlugIn flags, a combination of @ref WPIF_xxx "WPIF_xxx"
//optional
	/*!	@brief pointer to PlugIn dependices
		@remarks comma separated string of dependices each consisting of PlugIn-name [: min-PlugIn-version]
	*/
	LPCSTR	pDependices;
};


/*! @defgroup WPIF_xxx Wintruder PlugIn flags*/
//@{
#define WPIF_SYSTEM (1<<0)	//!< system PlugIn (reserved)
#define WPIF_STATIC	(1<<1)	//!< once loaded the PlugIn cannot be unloaded
#define WPIF_FORCE (1<<2)	//!< always load PlugIn
#define WPIF_TRIGGER (1<<30)	//!< used internally (bit 24-31 reserved)
#define WPIF_DISABLED (1<<31)	//!< used internally
//@}

/*! @defgroup WPICMD_xxx Wintruder PlugIn command*/
//@{
#define WPICMD_MENU 0			//!< query menu 
#define WPICMD_MENUCMD 1		//!< menu command
#define WPICMD_MENUUPDATE 2		//!< menu update

#define WPICMD_TOOLBAR 8		//!< query toolbar
#define WPICMD_TOOLCMD 9		//!< toolbar command
#define WPICMD_TOOLUPDATE 10	//!< toolbar update

#define WPICMD_SIZEBUFFER 2048	//!< size of command buffer
//@}

class Symbol;
class Interface;
class Process;
class Thread;
class Exception;

/**************************************
	functions exported by plugin
**************************************/
#ifdef WINTRUDER_SDK
	#define LIBFNC_WPI
#else
	#define LIBFNC_WPI __declspec(dllexport)
#endif
//mandatory
	/*! @brief plugin load callback
		@details required function to be exported by all plug in modules
		@param version Wintruder version
		@param hWndMainFrame handle of Wintruders main window
		@param bTrigger if none zero no initialization is required, the plug in in loaded to get WPI_Data only
		@param pReserved
		@returns pointer to WPI_Data if successful, NULL otherwise
	*/
	LIBFNC_WPI const struct WPI_Data* WPI_Load(DWORD version,HWND hWndMainFrame,BOOL bTrigger,void *pReserved);
//optional
	/*! @brief plugin unload callback
		@param bForce if nonezero the plugin will be unloaded regardless of the value returned
		@returns nonezero if the plugin can be unloaded now
	*/
	LIBFNC_WPI BOOL WPI_Unload(BOOL bForce);

	/*!	@brief plugin exception callback
		@details informs the plug in about any kind of debug exception that occured
		@param pInterface Interface that received the exception
		@param pProcess Process assigned to exception (NULL in some rare conditions)
		@param pThread Thread assigned to exception, may be NULL
		@param pException Exception information
		@param pData raw exception data (Interface and Exception depending)
		@returns must return a value of @ref EVC_xxx
	*/
	LIBFNC_WPI int WPI_Exception(Interface *pInterface,Process *pProcess,Thread *pThread,Exception *pException,void *pData);
	/*!	@brief plugin broadcast callback
		@param message a value of @ref BROADCAST_xxx "BROADCAST_xxx"
		@param data @em message specific data
		@returns return value currently ignored, the function should return zero
		@sa @ref Broadcast.doc
	*/
	LIBFNC_WPI LRESULT WPI_Broadcast(WPARAM message,LPARAM data);
	/*!	@brief plugin command callback
		@details this callback function is used for gui extension and gui command handling
		@param cmdId a value of @ref WPICMD_xxx "WPICMD_xxx"
		@param winId a value of @ref WIN_xxx "WIN_xxx"
		@param hWndFrame handle of frame window
		@param item command specific data
		@param data command specific buffer
		@returns command specific return value, zero if command not handled
		@sa @ref Command.doc
	*/
	LIBFNC_WPI int WPI_Command(UINT cmdId,UINT winId,HWND hWndFrame,UINT item,char data[WPICMD_SIZEBUFFER]);
/**************************************
	functions exported by wintruder
**************************************/
#ifdef WINTRUDER_SDK
	#define LIBFNC __declspec(dllexport)
#else
	#define LIBFNC __declspec(dllimport)

	typedef struct __POSITION *POSITION;
#endif

//globals
	/*!	@brief get Wintruder RootSymbol
		@return RootSymbol collection of all Symbol items
	*/
	LIBFNC Symbol* GetRootSymbol();
	/*!	@brief create a predefined symbol
		@see CreateSymbol.doc
	*/
	LIBFNC Symbol* CreateSymbol(Symbol* pParent,DWORDLONG symId,...);

#ifdef __cplusplus
}
#endif

#pragma pack(pop)
