/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#pragma warning(push)
#pragma warning(disable:4200)

#pragma pack(push,1)

struct _sym_type_header
{
	WORD size;
	BYTE type;
};

struct _sym_storage
{
	enum
	{
		typeNone,
		typeRva,
		typeStatic,
		typeThisRel,
		typeRegRel,
		typeReg,
		typeBitField,
		typeMetadata,
		typeConst,
		typeVTable,
		typeIndex,
		typeArg,
		typeAbsolute,
		typeInterpreter
	};
	BYTE type;
};
struct _sym_storage_rva
{
	DWORD rva;
};
struct _sym_storage_static
{
	DWORD section;
	DWORD offset;
};
struct _sym_storage_thisrel
{
	LONG offset;
};
struct _sym_storage_reg
{
	DWORD reg;
};
struct _sym_storage_regrel
{
	DWORD reg;
	LONG offset;
};
struct _sym_storage_bitfield
{
	LONG offset;
	BYTE bitposition;
	BYTE length;
};
struct _sym_storage_metadata
{
	DWORD token;
	DWORD rva;
};
struct _sym_storage_const
{
	BYTE size;
	BYTE data[];
};
struct _sym_storage_vtable
{
	DWORD vtableoffset;
};
struct _sym_storage_index
{
	DWORD index;
};
struct _sym_storage_arg
{
	DWORD index;
};
struct _sym_storage_absolute
{
	DWORDLONG absolute;
};
struct _sym_storage_interpreter
{
	DWORDLONG item;
	DWORD stack;
};
union _sym_storage_all
{
	_sym_storage_rva _rva;
	_sym_storage_static _static;
	_sym_storage_thisrel _thisrel;
	_sym_storage_reg _reg;
	_sym_storage_regrel _regrel;
	_sym_storage_bitfield _bitfield;
	_sym_storage_metadata _metadata;
	_sym_storage_const _const;
	_sym_storage_vtable _vtable;
	_sym_storage_index _index;
	_sym_storage_arg _arg;
	_sym_storage_absolute _absolute;
	_sym_storage_interpreter _interpreter;
};

struct _sym_storage_data
{
	_sym_storage store;
	_sym_storage_all all;
};

/*!
<table><tr>
<td>
@code
union _sym_type
{
	DWORD SymType;
	struct
	{
		WORD Size;
		BYTE _Pad;
		BYTE Type;
	};
};
@endcode
@code
union _sym_type
{
	DWORD SymType;
	struct
	{
		DWORD Size:24;
		DWORD Type:8;
	};
};
@endcode
</td><td>
@code
union _sym_type
{
	DWORD SymType;
	struct
	{
		WORD Size;
		BYTE SubSize;	
		BYTE Type;
	};
};
@endcode
</td>
</tr></table>
Usually Size should be sufficient to hold the symbols size, if not the higher 
bits are stored in SubSize.
in case of _sym_typeMMpi, _sym_typeMMpu, _sym_typeMMpf

*/
typedef DWORD _sym_type;



#define _sym_typeTYPE(x) ((x)&0xff000000)
#define _sym_typeSIZE(x) ((x)&0x00ffffff)
#define _sym_typeMAKE(type,size) ((type)|(size))

#define _sym_typeSetTYPE(x,type)	x=_sym_typeMAKE(type,_sym_typeSIZE(x))
#define _sym_typeSetSIZE(x,size)	x=_sym_typeMAKE(_sym_typeTYPE(x),size)

#define _sym_typeNone		0x00000000
#define _sym_typeVoid		0x01000000
#define _sym_typeChar		0x02000000
#define _sym_typeWChar		0x03000000
#define _sym_typeInt		0x04000000
#define _sym_typeUInt		0x05000000
#define _sym_typeFloat		0x06000000
#define _sym_typeBCD		0x07000000
#define _sym_typeBool		0x08000000
		
#define _sym_typeCurrency	0x10000000
#define _sym_typeDate		0x11000000
#define _sym_typeVariant	0x12000000
#define _sym_typeComplex	0x13000000
#define _sym_typeBit		0x14000000
#define _sym_typeBSTR		0x15000000
#define _sym_typeHRESULT	0x16000000
#define _sym_typeObject		0x17000000
#define _sym_typeSegment	0x18000000

#define _sym_typeString		0x1f000000

#define _sym_typeMM			0x20000000
#define _sym_typeMMpi		0x21000000
#define _sym_typeMMpu		0x22000000
#define _sym_typeMMpf		0x23000000

#define _sym_typeTypedRef	0x30000000

#define _sym_typeLabel		0x80000000
#define _sym_typeComment	0x81000000
#define _sym_typeProc		0x82000000
#define _sym_typeBlock		0x83000000
#define _sym_typeData		0x84000000
#define _sym_typeCodeBlock	0x85000000
#define _sym_typeArg		0x86000000
#define _sym_typeTypeDef	0x87000000

#define _sym_typePtr		0x90000000
#define _sym_typeArray		0x91000000
#define _sym_typeFunction	0x92000000
#define _sym_typeUdt		0x93000000
#define _sym_typeVTable		0x94000000
#define _sym_typeBaseClass	0x95000000
#define _sym_typeEnum		0x96000000
#define _sym_typeEnumerate	0x97000000

#define _sym_typeTypeRef	0xa0000000
#define _sym_typeScope		0xa1000000
#define _sym_typeValueType	0xa2000000

#define _sym_typeList		0xf0000000



struct _sym_name
{
	BYTE data[0];
};

/*!	@remarks unique by
		- @em classparent
		- @em name
*/
struct _sym_typedef
{
	_sym_type classparent;
	_sym_type type;
	_sym_name name;
};

/*!	@remarks unique by
		- @em parent
		- @em name
*/
struct _sym_label
{
	_sym_type parent;
	_sym_storage storage;
	//_sym_storage_
	//_sym_name name
};
/*!	@remarks unique by 
		- @em storage
		- @em shortname
*/
struct _sym_comment
{
	_sym_storage storage;
	//_sym_storage_
	//_sym_name	shortname;
	//_sym_name comment
};

union _sym_proc_flags
{
	struct
	{
		BYTE attrib;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- @em parent
		- @em methodtype
		- @em name
*/
struct _sym_proc
{

	enum
	{
		attribProc=0,
		attribEvent,
		attribThunk,
		attribChunk
	};
	_sym_type parent;
	_sym_type methodtype;
	DWORD size;
	_sym_proc_flags flags;
	_sym_type chunkData;
	_sym_type locales;
	_sym_type codeBlockList;
	_sym_storage storage;
//	_sym_storage_
//	_sym_name name;
};

/*!	@remarks unique by
		- @em parent
		- @em name
*/
struct _sym_block
{
	_sym_type parent;
	DWORD size;
	_sym_type locales;
	_sym_storage storage;
//	_sym_storage_
//	_sym_name name;
};

/*!	@remarks unique by
		- @em parent
		- @em name
*/
struct _sym_data
{
	_sym_type parent;
	_sym_type type;
	_sym_storage storage;
//	_sym_storage_
//	_sym_name name;
};

/*!	@remarks unique by 
		- all members
*/
struct _sym_arg
{
	_sym_type type;
	_sym_storage storage;
//	_sym_storage_
//	_sym_name name;
};

/*!	@remarks unique by 
		- all members
*/
struct _sym_codeblock
{
	DWORD offset;
	DWORD size;
	BYTE type;
};

union _typ_ptr_flags
{
	struct 
	{
		BYTE freference:1;
		BYTE ffar:1;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_ptr
{
	BYTE size;
	_typ_ptr_flags flags;
	_sym_type type;
};

union _typ_array_flags
{
	struct
	{
		BYTE type;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_array
{
	enum
	{
		typeNone,
		typeBounds,
		typeSize
	};
	_sym_type type;
	DWORD base;			//size if typeSize
	DWORD limit;
	_typ_array_flags flags;
};

union _typ_function_flags
{
	struct 
	{
		BYTE fcalling:5;
		BYTE ffar:1;
		BYTE fframe:2;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_function
{
	enum
	{
		callC,
		callPascal,
		callFast,
		callStd,
		callSys,
		callThis,
		callGeneric,

		callManagedDefault,
		callManagedDefaultThis,
		callManagedVArg,
		callManagedVArgThis
	};
	enum
	{
		frameNo,
		frameYes,
		frameUnknown
	};
	_sym_type returntype;
	_sym_type arglist;
	_typ_function_flags flags;
	DWORD thisadjust;
};
union _typ_udt_flags
{
	struct
	{
		BYTE type:4;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- @em classparent
		- @em name
*/
struct _typ_udt
{
	enum
	{
		typeClass,		//c++
		typeStruct,
		typeUnion,

		typeForm,		//basic
		typeModule,
		typePropertyPage,
		typeUserCtrl,
		typeCtrl,

		typeInterface,
		typeContainer	//metadata
	};

	_sym_type classparent;
	DWORD size;
	_typ_udt_flags flags;
	_sym_type baselist;
	_sym_type methodlist;
	_sym_type memberlist;
	_sym_type vtable;
	_sym_storage storage;
//	_sym_storage_
//	_sym_name name;
};
union _typ_vtable_flags
{
	BYTE type;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_vtable
{
	_typ_vtable_flags flags[];
};
union _typ_baseclass_flags
{
	struct
	{
		BYTE fvirtual:1;
		BYTE findirect:1;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_baseclass
{
	_typ_baseclass_flags flags;
	DWORD offset;
	DWORD index;
	_sym_type type;
};
/*!	@remarks unique by
		- @em classparent
		- @em name
*/
struct _typ_enum
{
	_sym_type list;
	_sym_type classparent;
	_sym_name name;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_enumerate
{
	_sym_storage storage;
//	_sym_storage_	//const
//	_sym_name name;
};

/*!	@remarks unique by
		- @em types
*/
struct _typ_list
{
	WORD refCount;
	_sym_type types[];
};

/*!	@remarks unique by
		- all members
*/
struct _typ_typeref
{
	_sym_type scope;
	_sym_storage storage;
//	_sym_storage_	//metadata
//	_sym_name name;
};

union _typ_scope_flags
{
	struct
	{
		BYTE type;
	};
	BYTE raw;
};
/*!	@remarks unique by
		- all members
*/
struct _typ_scope
{
	enum
	{
		typeAssembly,
		typeModule
	};
	_typ_scope_flags flags;
	_sym_storage storage;
//	_sym_storage_	//metadata
//	_sym_name name;
};

/*!	@remarks unique by
		- all members
*/
struct _typ_valuetype
{
	_sym_type type;
};


#pragma pack(pop)

#pragma warning(pop)
