// h_dialog.cpp : implementation file
//

#include "stdafx.h"
#include "heaplist.h"
#include "h_dialog.h"
#include "..\obsidian\obsidian.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// h_dialog dialog


h_dialog::h_dialog(CWnd* pParent /*=NULL*/)
	: CDialog(h_dialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(h_dialog)
	//}}AFX_DATA_INIT

	heap_list = NULL;
	heap_list_size = 0;
}


void h_dialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(h_dialog)
	DDX_Control(pDX, IDC_HEAP_NEIGHBORHOOD, m_neighborhood);
	DDX_Control(pDX, IDC_LIST1, m_blocklist);
	DDX_Control(pDX, IDC_HEAP_HEAPSTREE, m_heaptree);
	DDX_Control(pDX, IDC_CHECK1, m_stopHeapAdd);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(h_dialog, CDialog)
	//{{AFX_MSG_MAP(h_dialog)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_REFRESH, OnRefresh)
	ON_BN_CLICKED(IDC_HEAP_SHOW_NEIGHBORHOOD, OnHeapShowNeighborhood)
	ON_NOTIFY(TVN_SELCHANGED, IDC_HEAP_HEAPSTREE, OnSelchangedHeapHeapstree)
	ON_NOTIFY(NM_SETFOCUS, IDC_HEAP_HEAPSTREE, OnSetfocusHeapHeapstree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// h_dialog message handlers

void h_dialog::OnClose() 
{
	for(int i=0;i<heap_list_size;i++)
	{
		for(int j=0;j<128;j++)
		{
			if(heap_list[i].lookaside[j].count > 0)
				free(heap_list[i].lookaside[j].list);

			if(heap_list[i].free[j].count > 0)
				free(heap_list[i].free[j].list);
		}
	}
	
	CDialog::OnClose();
}

BOOL h_dialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	init_blocklist();
	fillin();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void h_dialog::OnRefresh() 
{
	fillin();	
}

void h_dialog::OnSelchangedHeapHeapstree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	HTREEITEM sel = m_heaptree.GetSelectedItem();

	for(int i=0;i<heap_list_size;i++)
	{
		for(int j=0;j<128;j++)
		{
			if(heap_list[i].free[j].tItem == sel)
			{
				display_blocklist(&heap_list[i].free[j], &heap_list[i].free[j]);
				break;
			}
		}

		if(j!=127)
		{
			for(j=0;j<128;j++)
			{
				if(heap_list[i].lookaside[j].tItem == sel)
				{
					display_blocklist(&heap_list[i].lookaside[j], &heap_list[i].lookaside[j]);
					break;
				}
			}
		}


	}

	
	*pResult = 0;
}

void h_dialog::OnSetfocusHeapHeapstree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnSelchangedHeapHeapstree(pNMHDR,pResult);
	
	*pResult = 0;
}

int h_dialog::init_blocklist()
{
	m_blocklist.InsertColumn(0,"Address",LVCFMT_LEFT,80);

	m_blocklist.InsertColumn(1,"Size",LVCFMT_LEFT,50);
	m_blocklist.InsertColumn(2,"Previous Size",LVCFMT_LEFT,80);
	m_blocklist.InsertColumn(3,"Cookie",LVCFMT_LEFT,55);
	m_blocklist.InsertColumn(4,"Flags",LVCFMT_LEFT,50);
	m_blocklist.InsertColumn(5,"Unused Byte",LVCFMT_LEFT,80);
	m_blocklist.InsertColumn(6,"Segment Index",LVCFMT_LEFT,90);
	m_blocklist.InsertColumn(7,"Forward Link",LVCFMT_LEFT,100);
	m_blocklist.InsertColumn(8,"Backward Link",LVCFMT_LEFT,100);
	m_blocklist.InsertColumn(9,"Content",LVCFMT_LEFT,150);


	return 0;
}

int h_dialog::display_blocklist(blocklist *list, blocklist *old)
{
	m_blocklist.DeleteAllItems();

	for(int i=list->count-1;i>=0;i--)
	{
		display_block(&list->list[i],&old->list[i]);
	}

	return 0;
}

int h_dialog::display_block(blocklist_display *block, blocklist_display *old)
{
	char buffer[254];
	int index;

	if(block->type&BLOCK_READ_ERROR)
	{
		sprintf(buffer,"Read Error at 0x%08x",block->addr);
		index = m_blocklist.InsertItem(0,buffer);
	}
	else
	{
		sprintf(buffer,"0x%08x",block->addr);
		index = m_blocklist.InsertItem(0,buffer);
	}

	sprintf(buffer,"0x%04x",block->head.ssize);
	m_blocklist.SetItemText(index,1,buffer);

	sprintf(buffer,"0x%04x",block->head.psize);
	m_blocklist.SetItemText(index,2,buffer);

	sprintf(buffer,"0x%02x",block->head.cookie);
	m_blocklist.SetItemText(index,3,buffer);

	sprintf(buffer,"0x%02x",block->head.flags);
	m_blocklist.SetItemText(index,4,buffer);

	sprintf(buffer,"0x%02x",block->head.unused);
	m_blocklist.SetItemText(index,5,buffer);

	sprintf(buffer,"0x%02x",block->head.seg_index);
	m_blocklist.SetItemText(index,6,buffer);

	sprintf(buffer,"0x%04x",block->head.flink);
	m_blocklist.SetItemText(index,7,buffer);

	sprintf(buffer,"0x%04x",block->head.blink);
	m_blocklist.SetItemText(index,8,buffer);


	return 0;
}

int h_dialog::fillin()
{
	// Heap32First seems to hangs if something on one heap ist corrupted
	if(!m_stopHeapAdd.GetCheck())
	{
		DWORD pid = OBSIDIAN->GetProcID();
		HANDLE sh = CreateToolhelp32Snapshot(TH32CS_SNAPHEAPLIST,pid);

		if(sh < 0)
			return -1;

		addAllHeaps(sh,pid);

		CloseHandle(sh);
	}

	display_heaps();
	
	return 0;
}

int h_dialog::addAllHeaps(HANDLE snapshot, DWORD pid)
{
	HEAPLIST32 hl;
	HEAPENTRY32 he;


	// I HATE the Toolhelp-API!

	hl.dwSize = sizeof(HEAPLIST32);
	he.dwSize = sizeof(HEAPENTRY32);

	if(!Heap32ListFirst(snapshot, &hl))
	{
		MessageBox("Error: Heap enumeration failed.");
		return -1;
	}

	if(!Heap32First(&he,pid,hl.th32HeapID))
	{
		MessageBox("Error: Heap enumeration failed.");
		return -1;
	}

	addHeap(&he);

		/*
		he.dwSize = sizeof(HEAPENTRY32);
		while(Heap32Next(&he))
		{
			addHeap(&he);
			he.dwSize = sizeof(HEAPENTRY32);
		}*/



	hl.dwSize = sizeof(HEAPLIST32);
	while(Heap32ListNext(snapshot,&hl))
	{
		if(!Heap32First(&he,pid,hl.th32HeapID))
		{
			MessageBox("Error: Heap enumeration failed.");
			return -1;
		}
		addHeap(&he);

		/*
		he.dwSize = sizeof(HEAPENTRY32);
		while(Heap32Next(&he))
		{
			addHeap(&he);
			he.dwSize = sizeof(HEAPENTRY32);
		}*/

		hl.dwSize = sizeof(HEAPLIST32);
	}


	return 0;
}

int h_dialog::display_heaps()
{
	char buf[128];
	HTREEITEM free,lookaside;

	for(int i=0;i<heap_list_size;i++)
	{

		refreshHeap(&heap_list[i]);

		if(heap_list[i].treeentry != 0)
		{
			m_heaptree.DeleteItem(heap_list[i].treeentry);
		}

		sprintf(buf,"0x%08x",heap_list[i].handle);
		heap_list[i].treeentry = m_heaptree.InsertItem(buf,TVI_ROOT);

		free = m_heaptree.InsertItem("Free List",heap_list[i].treeentry,TVI_LAST);
		for(int j=0;j<128;j++)
		{
			if(heap_list[i].free[j].count > 0)
			{
				sprintf(buf,"[%i] (%i Entries a %i Bytes)",j,heap_list[i].free[j].count,j*8);
				heap_list[i].free[j].tItem = m_heaptree.InsertItem(buf,free,TVI_LAST);
			}
		}

		lookaside = m_heaptree.InsertItem("Lookaside List",heap_list[i].treeentry,TVI_LAST);
		for(j=0;j<128;j++)
		{
			if(heap_list[i].lookaside[j].count > 0)
			{
				sprintf(buf,"[%i] (%i Entries a %i Bytes)",j,heap_list[i].lookaside[j].count,j*8);
				heap_list[i].lookaside[j].tItem = m_heaptree.InsertItem(buf,lookaside,TVI_LAST);
			}
		}
		
	}

	return 0;
}

int h_dialog::addHeap(HEAPENTRY32 *he)
{
	for(int i=0;i<heap_list_size;i++)
		if(heap_list[i].handle == he->hHandle)
			return 1;


	heap_list_size++;
	heap_list = (heap_list_struct*)realloc(heap_list,heap_list_size*sizeof(heap_list_struct));

	memset(&heap_list[heap_list_size-1],0x00,sizeof(heap_list_struct));
//	memset((heap_list+((heap_list_size-1)*sizeof(heap_list_struct))),0x00,sizeof(heap_list_struct));
	heap_list[heap_list_size-1].handle = he->hHandle;

	refreshHeap(&heap_list[heap_list_size-1]);

	return 0;
}

int h_dialog::refreshHeap(heap_list_struct *heap)
{
	refreshLookaside(heap);
	refreshLinkedList(heap);

	return 0;
}

int h_dialog::refreshLookaside(heap_list_struct *heap)
{
	int read;
	win_lookaside_list_header	headers[128];

	read = OBSIDIAN->ReadMemory((DWORD)heap->handle+0x688,headers,sizeof(win_lookaside_list_header)*128);
	if(read!=sizeof(win_lookaside_list_header)*128)
	{
		char buf[256];
		sprintf(buf,"Error: Failed reading lookaside headers for heap 0x%08x.",(DWORD)heap->handle);
		MessageBox(buf);
		return -1;
	}

	for(int i=0;i<128;i++)
	{
		if(headers[i].addr != NULL)
		{
			// hier noch alten wert sichern
			if(heap->lookaside[i].list != NULL)
				free(heap->lookaside[i].list);

			heap->lookaside[i].list = walkLookaside(headers[i].addr,&heap->lookaside[i].count);
		}
	}
			
	return 0;
}

blocklist_display* h_dialog::walkLookaside(DWORD first, int *count)
{
	int read;
	DWORD	next;
	blocklist_display* list = (blocklist_display*)malloc(sizeof(blocklist_display)), *act;
	int c = 0;

	list[c].addr = first - 8;
	list[c].type = BLOCK_TYPE_LOOKASIDE;
	read = OBSIDIAN->ReadMemory(list[0].addr,(void*)&list[c].head,sizeof(heap_header));

	next = list[c].head.flink;	

	if(read!=sizeof(heap_header))
	{
		list[c].type |= BLOCK_READ_ERROR;
		next = NULL;
	}
	
	while(next!=NULL && c<19)
	{
		c++;
		list = (blocklist_display*)realloc(list,sizeof(blocklist_display)*(c+1));
		act = &list[c];

		act->addr = next - 8;
		act->type = 0;

		if((read = OBSIDIAN->ReadMemory(act->addr,&act->head,sizeof(heap_header)))!=sizeof(heap_header))
		{
			act->type |= BLOCK_READ_ERROR;
			break;
		}

		next = act->head.flink;
	}


	*count = ++c;
	return list;
}

int h_dialog::refreshLinkedList(heap_list_struct *heap)
{
	win_linked_list_header headers[128];

	if(OBSIDIAN->ReadMemory((DWORD)heap->handle+0x178,headers,sizeof(win_linked_list_header)*128)!=sizeof(win_linked_list_header)*128)
	{
		MessageBox("Failed reading linked list headers.");
		return -1;
	}

	for(int i=0;i<128;i++)
	{
		if(heap->free[i].list != NULL)
			free(heap->free[i].list);

		if(!((headers[i].flink==headers[i].blink)&&(headers[i].flink==(DWORD)heap->handle+0x178+8*i)))
			heap->free[i].list = walkLinkedList(headers[i].flink,headers[i].blink,(DWORD)heap->handle+0x178+8*i,&heap->free[i].count);
	}

	return 0;
}

blocklist_display* h_dialog::walkLinkedList(DWORD first, DWORD last, DWORD header_addr, int *count)
{
	int c = 0, error=0;
	blocklist_display* list = NULL;
	blocklist_display cur;
	DWORD	back = 0;

	memset(&cur,0x00,sizeof(cur));
	cur.addr = first - 8;


	// Vorwrts
	do
	{		
		cur.type = BLOCK_TYPE_FREE;
		c++;

		if(OBSIDIAN->ReadMemory(cur.addr,&cur.head,sizeof(heap_header))!=sizeof(heap_header))
		{
			cur.type |= BLOCK_READ_ERROR;
			error = 1;
		}

		if(back!=0 && cur.head.blink!=(back+8))
			cur.type |= BLOCK_LIST_INCONSISTENT;


		back = cur.addr;

		list = (blocklist_display*)realloc(list,sizeof(blocklist_display)*(c));
		memcpy(&list[c-1],&cur,sizeof(blocklist_display));

		if(cur.addr == cur.head.flink - 8)
			break;

		cur.addr = cur.head.flink - 8;
	}
	while(cur.addr!=first-8 && !error && first!=last && cur.addr!=header_addr-8);

/*
	if(error)
	{
		int backc = 0, be=0;
		blocklist_display* backlist=(blocklist_display*)malloc(sizeof(blocklist_display)), *bc;
		back = 0;

		backlist[0].addr = last;

		do
		{
			backc++;

			backlist = (blocklist_display*)realloc(backlist,sizeof(blocklist_display)*backc);
			bc = &backlist[backc-1];

			if(OBSIDIAN->ReadMemory(bc->addr,&bc->head,sizeof(heap_header))!=sizeof(heap_header))
			{
				bc->type |= BLOCK_READ_ERROR;
				be = 1;
			}	

			if(back!=0 && bc->head.blink!=(back+8))
				bc->type |= BLOCK_LIST_INCONSISTENT;
		}
		while(true);
	}*/

	*count = c;
	return list;
}

void h_dialog::OnHeapShowNeighborhood() 
{
	char str[64];
	DWORD	addr;
	blocklist list;
	
	list.tItem = NULL;

	m_neighborhood.GetWindowText(str,63);

	addr = strtol(str,NULL,16);

	list.list = getNeighborhood(addr,NEIGHBORHOOD_BY_BLOCKS,5,5,&list.count);
	display_blocklist(&list,&list);

	free(list.list);
}

blocklist_display* h_dialog::getNeighborhood(DWORD addr,int type, int forward, int backward, int *count)
{
	blocklist_display*	list;

	if(type & NEIGHBORHOOD_BY_BLOCKS)
	{
		list = (blocklist_display*)malloc(sizeof(blocklist_display)*(forward+backward+1));

		list[backward].addr = addr;
		list[backward].type = 0;

		if(OBSIDIAN->ReadMemory(addr,(void*)&list[backward].head,sizeof(heap_header))!=sizeof(heap_header))
		{
			free(list);
			return NULL;
		}

		for(int i=1;i<=backward;i++)
		{
			list[backward-i].addr = list[backward-i+1].addr - (list[backward-i+1].head.psize * 8);
			list[backward-i].type = 0;

			if(OBSIDIAN->ReadMemory(list[backward-i].addr,(void*)&list[backward-i].head,sizeof(heap_header))!=sizeof(heap_header))
			{
				list[backward-i].type |= BLOCK_READ_ERROR;
				break;
			}
		}

		for(i=1;i<=forward;i++)
		{
			list[backward+i].addr = list[forward+i-1].addr + (list[forward+i-1].head.ssize * 8);
			list[backward+i].type = 0;

			if(OBSIDIAN->ReadMemory(list[backward+i].addr,(void*)&list[backward+i].head,sizeof(heap_header))!=sizeof(heap_header))
			{
				list[backward+i].type |= BLOCK_READ_ERROR;
				break;
			}
		}


	}
	else
		return NULL;



	*count = (forward+backward+1);
	return list;
}
